////////////////////////////////////////////////////////////////////////////////

/**
 * options:
 *    X Int kontrahent - id kontrahenta
 *		X Url endpoint - url to fetch data from
 *		Array actions - list of actions
 *		X String title - dialog title
 *		X Callback enable(en) - callback
 *
 *		kontrahent
 *
 */
function tasksDialog(options) {
	var originalData;
	var filteredData;
	var sortedData;
	var vat = options.vat;
	var BROWSER;

	var actionSelect = {
		title: 'Wybierz',
		handler: function(task, link) {
			if (options.tasks >= options.maxTasks)
				showMessage('Informacja', 'Nie możesz podjąć się wiekszej ilości zleceń na tym etapie gry.');
			else {
				var template = '<div>' +
					'<div class="barbutton2 hover2" style="cursor: default; background: url(\'' + window.links.baseUrl + '/images/gui/info-icon-sm.png\') no-repeat; width:35px; height: 35px; float: left; border:0; padding:0; position: absolute; top:7px; left:2px; z-index: 999;"></div>' +
					'<div class="row" style="text-align:center;padding-left:40px;padding-right:40px">UMOWA O ŚWIADCZENIE USŁUG</div>' +
					'<div class="register-form-left" style="float: right;"><div class="row infodiv" style="width: calc(100% - 40px);font-size:small;margin-top: 1px;margin-left: 10px;margin-right: 10px;margin-bottom: 10px;">' +
					'<p style="margin-bottom:1em">Zawarta dnia ' + $.datepicker.formatDate('yy-mm-dd', new Date()) + ' roku, w miejscowości: ' + options.city + ' pomiędzy ' + userdata.nazwa_firmy + ' zwaną dalej „Wykonawcą”, a ' + task.kontrahent.nazwa + ' zwaną dalej „Zamawiającym”, o treści następującej: </p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$1</p>' +
					'<p style="margin-bottom:1em">Wykonawca zobowiązuje się do realizacji zadania ' + task.dziedzina + (task.kategoria ? ' - ' + task.kategoria : '') + ' - ' + task.poziom + ' na rzecz Zamawiającego.</p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$2</p>' +
					'<p style="margin-bottom:1em">Z tytułu wykonania zleceń wchodzących w zakres niniejszej umowy Zamawiający zapłaci Wykonawcy wynagrodzenie w wysokości ' + task.cena + ' zł netto.</p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$3</p><ol>' +
					'<li>Wykonawca zobowiązuje się do wykonania zadania w terminie ' + options.periodDays + ' dni od daty popisania umowy.</li>' +
					'<li>Zamawiający rości sobie prawo do nałożenia na Wykonawcę kary w wysokości ' + task.kara + '% kwoty wartości zlecenia (' + (task.kara / 100 * task.cena) + ' zł).</li>' +
					'</ol></div></div>' +
					'<div style="margin-left:15px">Przydziel do: ' + options.workerList + '</div>' +
					'</div>';
				$(template).dialog({
					title: 'Umowa',
					modal: true,
					autoOpen: true,
					closeOnEscape: false,
					open: function() {
						var dlg = $(this);
						dlg.find('select').change(function() {
							dlg.find('.stats').remove();
							var select = $(this);
							var sel = select.val();
							var workerId = -1;
							if (sel.indexOf('w') === 0)
								workerId = sel.substring(1);
							else return;
							$.ajax({
								type: 'GET',
								url: window.links.studentAjaxSimTaskAssign,
								data: {
									taskId: task.id,
									workerId: workerId
								},
								success: function(data) {
									if (data.stats) {
										var s = data.stats;
										var durationColor;
										if (s.duration < s.taskEnd)
											durationColor = 'green';
										else if (s.duration > s.taskEnd)
											durationColor = 'red';
										else
											durationColor = 'yellow';
										var gradient = [{
											value: 0.00,
											color: [255, 000, 000]
										}, {
											value: 0.60,
											color: [255, 000, 000]
										}, {
											value: 0.75,
											color: [255, 255, 000]
										}, {
											value: 0.95,
											color: [000, 255, 000]
										}, {
											value: 1.00,
											color: [000, 255, 000]
										}];
										var color = [0, 0, 0];
										for (var i = 0; i < gradient.length - 1; i++) {
											var A = gradient[i];
											var B = gradient[i + 1];
											if (s.propability >= A.value && s.propability <= B.value) {
												var sum = (B.value - A.value);
												var a = 1 - (s.propability - A.value) / sum;
												var b = 1 - (B.value - s.propability) / sum;
												color = [
													Math.round(a * A.color[0] + b * B.color[0]),
													Math.round(a * A.color[1] + b * B.color[1]),
													Math.round(a * A.color[2] + b * B.color[2])
												];
												break;
											}
										}
										var html = '<span style="padding-left:5px;font-weight:bold;" class="stats"><span style="color:' + durationColor + '">' + s.duration + ' ' + s.durationUnit + '</span> <span style="text-shadow:1px 1px 2px black;color:rgb(' + color[0] + ', ' + color[1] + ', ' + color[2] + ')">' + Math.round(s.propability * 100) + '%</span></span>';
										select.after(html);
									}
								},
								complete: function() {
									options.enable(true);
								}
							});
						});
					},
					hide: {
						effect: 'clip',
						duration: 500
					},
					show: {
						effect: 'scale',
						duration: 600
					},
					close: function() {
						$(this).parent().remove();
					},
					position: {
						my: 'center',
						at: 'center',
						of: window
					},
					draggable: true,
					resizable: false,
					width: 500,
					height: 580,
					buttons: [{
						text: 'Zgadzam się',
						click: function() {
							var params = {
								taskId: task.id,
								kontrahentId: task.idKontrahenta
							};
							var sel = $(this).find('select').val();
							if (!sel) return;
							if (sel.indexOf('s') === 0)
								params.studentId = sel.substring(1);
							else if (sel.indexOf('w') === 0)
								params.workerId = sel.substring(1);
							var _dlg = $(this);
							options.enable(false);
							$.ajax({
								type: 'POST',
								url: window.links.studentAjaxTakeTask,
								data: params,
								success: function(data) {
									if (data.error)
										showMessage('Błąd', data.error);
									else {
										options.workerList = data.workerList;
										options.city = data.city;
										options.periodDays = data.periodDays;
										_dlg.dialog('close');
										BROWSER.find('.tasksBoxCount').text(++options.tasks);
										link.parent().parent().fadeOut(400, function() {
											$(this).remove();
										});
									}
								},
								complete: function() {
									options.enable(true);
								}
							});
						}
					}, {
						text: 'Anuluj',
						click: function() {
							$(this).dialog('close')
						}
					}, ]
				});
			}
		}
	};

	for (var i in options.actions) {
		var action = options.actions[i];
		if (action == 'Select')
			options.actions[i] = actionSelect;
	}

	var sorter = {
		field: null,
		order: '',
		run: function(display) {
			var _field = this.field;
			if (_field != null) {
				sortedData = filteredData.slice(0);
				var _order = this.order;
				if (_order.length)
					sortedData.sort(function(a, b) {
						return a[_field] == b[_field] ? 0 : (
							a[_field] < b[_field] ? (_order == 'asc' ? -1 : 1) : (_order == 'asc' ? 1 : -1)
						);
					});
			} else sortedData = filteredData;
			if (display == null) display = true;
			if (display) displayData();
		}
	}

	function installControls() {
		BROWSER.find('a.sort').off('click');
		BROWSER.find('a.sort').removeClass('asc').removeClass('desc');
		BROWSER.find('a.sort').on('click', function() {
			var _this = $(this);
			sorter.field = _this.attr('data-field');
			if (_this.hasClass('asc')) {
				_this.removeClass('asc');
				sorter.order = 'desc';
			} else if (_this.hasClass('desc')) {
				sorter.order = '';
				_this.removeClass('desc');
			} else sorter.order = 'asc';
			BROWSER.find('a.sort').removeClass('asc').removeClass('desc');
			_this.addClass(sorter.order);
			sorter.run();
			return false;
		});
		//===============================
		BROWSER.find('.filter').val('');
		BROWSER.find('.filter').off('change');
		BROWSER.find('.filter').on('change', function() {
			var _this = $(this);
			var value = _this.val();

			var filters = BROWSER.find('.filter');
			filteredData = [];
			for (var i in originalData) {
				var data = originalData[i];
				var push = true;
				for (var x = 0; x < filters.length; x++) {
					function filterNumber(operator, a, b) {
						if (operator === '=')
							push = push && a == b;
						else if (operator === '!')
							push = push && a != b;
						else if (operator === '>')
							push = push && a > b;
						else if (operator === '<')
							push = push && a < b;
						else
							push = push && a == b;
					}
					var filter = $(filters[x]);
					var value = filter.val();
					if (value != '') {
						var field = filter.attr('data-field');
						var inValue = data[field];
						if (filter.hasClass('time')) {
							var operator = value.substring(0, 1);
							var a = parseFloat(inValue);
							var b = timeToInt('=!<>'.indexOf(operator) > -1 ? value.substring(1) : value);
							filterNumber(operator, a, b);
						} else if (filter.hasClass('numeric')) {
							var operator = value.substring(0, 1);
							var a = parseFloat(inValue);
							var b = parseFloat('=!<>'.indexOf(operator) > -1 ? value.substring(1) : value);
							filterNumber(operator, a, b);
						} else if (filter.hasClass('text'))
							push = push && inValue !== undefined && inValue.toLowerCase().indexOf(value.toLowerCase()) > -1;
						else
							push = push && inValue == value;
					}
				}
				if (push) filteredData.push(data);
			}
			sorter.run();
		});
	}

	function findTask(id) {
		for (var x in sortedData)
			if (sortedData[x].id == id)
				return sortedData[x];
		return null;
	}

	function timeToInt(tm) {
		var arr = tm.split(':'),
			result = 0;
		for (var i = arr.length - 1, m = 1; i >= 0; i--, m *= 60)
			result += parseInt(arr[i]) * m;
		return result;
	}

	function displayData() {
		var html = '';
		if (sortedData == null || sortedData.length == 0)
			html = '<tr><td colspan="7" style="text-align:center;padding-top:20px;"><i>Brak wyników</i></td></tr>';
		else
			for (var i in sortedData) {
				var item = sortedData[i];
				var actions = '';
				if (item.allowed)
					for (var x in options.actions) {
						var act = options.actions[x];
						actions += '<a data-handler="' + x + '" class="action" taskId="' + item.id + '" href="#">[' + act.title + ']</a> ';
					}
				html += '<tr' + (!item.allowed ? ' class="disabled"' : '') + '>' +
					'<td><img src="' + window.links.baseUrl + '/images/gui/' + item.dziedzina.toLowerCase() + '.png" title="' + item.dziedzina + '" alt="' + item.dziedzina + '" /></td>' +
					'<td>' + (item.kategoria !== undefined ? item.kategoria : 'n/a') + '</td>' +
					'<td>' + item.poziom + '</td>' +
					'<td>' + parseFloat(item.cena * (1.0 + vat)).toFixed(2) + '</td>' +
					'<td>' + item.kara + '</td>' +
					'<td>' + formatInterval(item.czas) + '</td>' +
					'<td>' + actions + '</td>' +
					'</tr>';
			}
		BROWSER.find('.tasksBoxBody').html(html);
		for (var x in options.actions) {
			var objects = BROWSER.find('a.action[data-handler="' + x + '"]');
			objects.click(function() {
				var taskId = $(this).attr('taskId');
				var x = $(this).attr('data-handler');
				options.actions[x].handler(findTask(taskId), $(this), options);
				return false;
			});
		}
	}

	function refresh() {
		options.enable(false);
		BROWSER.find('.tasksBoxWait').find('td').text('Proszę czekać...');
		$.ajax({
			type: 'GET',
			url: options.endpoint,
			data: options.endpointParams,
			success: function(data) {
				if (data.error) {
					BROWSER.find('.tasksBoxWait').find('td').text(data.error);
					return;
				}
				options.maxTasks = data.max;
				options.tasks = data.cnt;
				BROWSER.find('.tasksBoxCount').text(options.tasks);
				BROWSER.find('.tasksBoxMaxCount').text(options.maxTasks);
				options.workerList = data.workerList;
				options.city = data.city;
				options.periodDays = data.periodDays;
				originalData = data.data;
				filteredData = originalData;
				sortedData = filteredData;
				installControls();
				BROWSER.find('.tasksBoxWait').fadeOut(400, function() {
					displayData();
					BROWSER.find('.tasksBoxContainer').fadeIn();
				});
			},
			error: function(xhr, status, error) {
				BROWSER.find('.tasksBoxWait').find('td').text(status + ' ' + error);
			},
			complete: function() {
				options.enable(true);
			}
		});
	}

	var dlgTemplate =
		'<div class="biuroZleceniaXrDialogCls" xid="biuroZleceniaXrDialog">' +
		'	<table class="tasksBoxWait">' +
		'		<tr>' +
		'			<td>Proszę czekać...</td>' +
		'		</tr>' +
		'	</table>' +
		'	<div class="tasksBoxContainer">' +
		'		<table class="tasksBoxContainerOuterTable">' +
		'			<thead>' +
		'				<tr>' +
		'					<th>' +
		'						<a class="sort" data-field="dziedzina" href="#">Dziedzina</a><br>' +
		'						<select class="filter" data-field="dziedzina" name="filter_dziedzina">' +
		'							<option value="" selected="selected"></option>' +
		'							<option value="Matematyka">Mat</option>' +
		'							<option value="Fizyka">Fiz</option>' +
		'							<option value="Biologia">Biol</option>' +
		'							<option value="Chemia">Chem</option>' +
		'						</select>' +
		'					</th>' +
		'					<th>' +
		'						<a class="sort" data-field="kategoria" href="#">Kategoria</a><br>' +
		'						<input size="10" class="filter text" data-field="kategoria" type="text" value="" name="filter_kategoria"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="poziom" href="#">Poziom</a><br>' +
		'						<select class="filter" data-field="poziom" name="filter_poziom">' +
		'							<option value="" selected="selected"></option>' +
		'							<option value="Łatwe">Łatwe</option>' +
		'							<option value="Trudne">Trudne</option>' +
		'							<option value="Bardzo trudne">Bardzo trudne</option>' +
		'						</select></th>' +
		'					<th>' +
		'						<a class="sort" data-field="cena" href="#">Cena [zł]</a><br>' +
		'						<input size="10" class="filter numeric" data-field="cena" type="text" value="" name="filter_cena"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="kara" href="#">Kara [%]</a><br>' +
		'						<input size="10" class="filter numeric" data-field="kara" type="text" value="" name="filter_kara"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="czas" href="#">Czas</a><br>' +
		'						<input size="10" class="filter time" data-field="czas" type="text" value="" name="filter_czas"></th>' +
		'					<th></th>' +
		'				</tr>' +
		'			</thead>' +
		'			<tbody class="tasksBoxBody">' +
		'			</tbody>' +
		'		</table>' +
		'		<div>' +
		'			<span style="float:right"><span class="tasksBoxCount">?</span> / <span class="tasksBoxMaxCount">?</span></span>' +
		'		</div>' +
		'	</div>' +
		'</div>';

	BROWSER = $(dlgTemplate);
	BROWSER.dialog({
		title: options.title,
		modal: true,
		autoOpen: true,
		closeOnEscape: false,
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		open: function() {
			refresh();
		},
		close: function() {
			BROWSER.find('.tasksBoxBody').html('');
			BROWSER.find('.tasksBoxContainer').hide();
			BROWSER.find('.tasksBoxWait').show();
			$(this).parent().remove();
		},
		position: {
			my: "center",
			at: "center",
			of: window
		},
		draggable: true,
		resizable: false,
		width: 950,
		height: 450
	});

	BROWSER.find('.tasksBoxBodyRefresh').click(function() {
		BROWSER.find('.tasksBoxContainer').fadeOut(400, function() {
			BROWSER.find('.tasksBoxWait').fadeIn(400, refresh);
		});
		return false;
	});
}

/* TASKS Dialog EN */

function tasksDialogEn(options) {
	var originalData;
	var filteredData;
	var sortedData;
	var vat = options.vat;
	var BROWSER;

	var actionSelect = {
		title: 'Select',
		handler: function(task, link) {
			if (options.tasks >= options.maxTasks)
				showMessage('Information', 'You cannot select more orders today.');
			else {
				var template = '<div>' +
					'<div class="barbutton2 hover2" style="cursor: default; background: url(\'' + window.links.baseUrl + '/images/gui/info-icon-sm.png\') no-repeat; width:35px; height: 35px; float: left; border:0; padding:0; position: absolute; top:7px; left:2px; z-index: 999;"></div>' +
					'<div class="row" style="text-align:center;padding-left:40px;padding-right:40px">SERVICES DELIVERY AGREEMENT</div>' +
					'<div class="register-form-left" style="float: right;"><div class="row infodiv" style="width: calc(100% - 40px);font-size:small;margin-top: 1px;margin-left: 10px;margin-right: 10px;margin-bottom: 10px;">' +
					'<p style="margin-bottom:1em">Signed on ' + $.datepicker.formatDate('yy-mm-dd', new Date()) + ' year, in the town of: ' + options.city + ' between ' + userdata.nazwa_firmy + ' hereinafter referred to as the „Contractor”, and ' + task.kontrahent.nazwa + ' hereinafter referred to as the „Employer”, which states as follows: </p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$1</p>' +
					'<p style="margin-bottom:1em">The Contractor undertakes to carry out the task ' + task.dziedzina + (task.kategoria ? ' - ' + task.kategoria : '') + ' - ' + task.poziom + ' for the Employer.</p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$2</p>' +
					'<p style="margin-bottom:1em">For the performance of contracts falling within the scope of this Agreement, the Employer will pay the salary of ' + task.cena + ' zł net.</p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$3</p><ol>' +
					'<li>The Contractor agrees to complete the task within ' + options.periodDays + ' 7 days from the date of signing the agreement.</li>' +
					'<li>The Employer reserves the right to require from the Contractor a penalty fee of ' + task.kara + '% of the order value (' + (task.kara / 100 * task.cena) + ' zł).</li>' +
					'</ol></div></div>' +
					'<div style="margin-left:15px">Assign to: ' + options.workerList + '</div>' +
					'</div>';
				$(template).dialog({
					title: 'Agreement',
					modal: true,
					autoOpen: true,
					closeOnEscape: false,
					open: function() {
						var dlg = $(this);
						dlg.find('select').change(function() {
							dlg.find('.stats').remove();
							var select = $(this);
							var sel = select.val();
							var workerId = -1;
							if (sel.indexOf('w') === 0)
								workerId = sel.substring(1);
							else return;
							$.ajax({
								type: 'GET',
								url: window.links.studentAjaxSimTaskAssign,
								data: {
									taskId: task.id,
									workerId: workerId
								},
								success: function(data) {
									if (data.stats) {
										var s = data.stats;
										var durationColor;
										if (s.duration < s.taskEnd)
											durationColor = 'green';
										else if (s.duration > s.taskEnd)
											durationColor = 'red';
										else
											durationColor = 'yellow';
										var gradient = [{
											value: 0.00,
											color: [255, 000, 000]
										}, {
											value: 0.60,
											color: [255, 000, 000]
										}, {
											value: 0.75,
											color: [255, 255, 000]
										}, {
											value: 0.95,
											color: [000, 255, 000]
										}, {
											value: 1.00,
											color: [000, 255, 000]
										}];
										var color = [0, 0, 0];
										for (var i = 0; i < gradient.length - 1; i++) {
											var A = gradient[i];
											var B = gradient[i + 1];
											if (s.propability >= A.value && s.propability <= B.value) {
												var sum = (B.value - A.value);
												var a = 1 - (s.propability - A.value) / sum;
												var b = 1 - (B.value - s.propability) / sum;
												color = [
													Math.round(a * A.color[0] + b * B.color[0]),
													Math.round(a * A.color[1] + b * B.color[1]),
													Math.round(a * A.color[2] + b * B.color[2])
												];
												break;
											}
										}
										var html = '<span style="padding-left:5px;font-weight:bold;" class="stats"><span style="color:' + durationColor + '">' + s.duration + ' ' + s.durationUnit + '</span> <span style="text-shadow:1px 1px 2px black;color:rgb(' + color[0] + ', ' + color[1] + ', ' + color[2] + ')">' + Math.round(s.propability * 100) + '%</span></span>';
										select.after(html);
									}
								},
								complete: function() {
									options.enable(true);
								}
							});
						});
					},
					hide: {
						effect: 'clip',
						duration: 500
					},
					show: {
						effect: 'scale',
						duration: 600
					},
					close: function() {
						$(this).parent().remove();
					},
					position: {
						my: 'center',
						at: 'center',
						of: window
					},
					draggable: true,
					resizable: false,
					width: 500,
					height: 580,
					buttons: [{
						text: 'I agree',
						click: function() {
							var params = {
								taskId: task.id,
								kontrahentId: task.idKontrahenta
							};
							var sel = $(this).find('select').val();
							if (!sel) return;
							if (sel.indexOf('s') === 0)
								params.studentId = sel.substring(1);
							else if (sel.indexOf('w') === 0)
								params.workerId = sel.substring(1);
							var _dlg = $(this);
							options.enable(false);
							$.ajax({
								type: 'POST',
								url: window.links.studentAjaxTakeTask,
								data: params,
								success: function(data) {
									if (data.error)
										showMessage('Błąd', data.error);
									else {
										options.workerList = data.workerList;
										options.city = data.city;
										options.periodDays = data.periodDays;
										_dlg.dialog('close');
										BROWSER.find('.tasksBoxCount').text(++options.tasks);
										link.parent().parent().fadeOut(400, function() {
											$(this).remove();
										});
									}
								},
								complete: function() {
									options.enable(true);
								}
							});
						}
					}, {
						text: 'Cancel',
						click: function() {
							$(this).dialog('close')
						}
					}, ]
				});
			}
		}
	};

	for (var i in options.actions) {
		var action = options.actions[i];
		if (action == 'Select')
			options.actions[i] = actionSelect;
	}

	var sorter = {
		field: null,
		order: '',
		run: function(display) {
			var _field = this.field;
			if (_field != null) {
				sortedData = filteredData.slice(0);
				var _order = this.order;
				if (_order.length)
					sortedData.sort(function(a, b) {
						return a[_field] == b[_field] ? 0 : (
							a[_field] < b[_field] ? (_order == 'asc' ? -1 : 1) : (_order == 'asc' ? 1 : -1)
						);
					});
			} else sortedData = filteredData;
			if (display == null) display = true;
			if (display) displayData();
		}
	}

	function installControls() {
		BROWSER.find('a.sort').off('click');
		BROWSER.find('a.sort').removeClass('asc').removeClass('desc');
		BROWSER.find('a.sort').on('click', function() {
			var _this = $(this);
			sorter.field = _this.attr('data-field');
			if (_this.hasClass('asc')) {
				_this.removeClass('asc');
				sorter.order = 'desc';
			} else if (_this.hasClass('desc')) {
				sorter.order = '';
				_this.removeClass('desc');
			} else sorter.order = 'asc';
			BROWSER.find('a.sort').removeClass('asc').removeClass('desc');
			_this.addClass(sorter.order);
			sorter.run();
			return false;
		});
		//===============================
		BROWSER.find('.filter').val('');
		BROWSER.find('.filter').off('change');
		BROWSER.find('.filter').on('change', function() {
			var _this = $(this);
			var value = _this.val();

			var filters = BROWSER.find('.filter');
			filteredData = [];
			for (var i in originalData) {
				var data = originalData[i];
				var push = true;
				for (var x = 0; x < filters.length; x++) {
					function filterNumber(operator, a, b) {
						if (operator === '=')
							push = push && a == b;
						else if (operator === '!')
							push = push && a != b;
						else if (operator === '>')
							push = push && a > b;
						else if (operator === '<')
							push = push && a < b;
						else
							push = push && a == b;
					}
					var filter = $(filters[x]);
					var value = filter.val();
					if (value != '') {
						var field = filter.attr('data-field');
						var inValue = data[field];
						if (filter.hasClass('time')) {
							var operator = value.substring(0, 1);
							var a = parseFloat(inValue);
							var b = timeToInt('=!<>'.indexOf(operator) > -1 ? value.substring(1) : value);
							filterNumber(operator, a, b);
						} else if (filter.hasClass('numeric')) {
							var operator = value.substring(0, 1);
							var a = parseFloat(inValue);
							var b = parseFloat('=!<>'.indexOf(operator) > -1 ? value.substring(1) : value);
							filterNumber(operator, a, b);
						} else if (filter.hasClass('text'))
							push = push && inValue !== undefined && inValue.toLowerCase().indexOf(value.toLowerCase()) > -1;
						else
							push = push && inValue == value;
					}
				}
				if (push) filteredData.push(data);
			}
			sorter.run();
		});
	}

	function findTask(id) {
		for (var x in sortedData)
			if (sortedData[x].id == id)
				return sortedData[x];
		return null;
	}

	function timeToInt(tm) {
		var arr = tm.split(':'),
			result = 0;
		for (var i = arr.length - 1, m = 1; i >= 0; i--, m *= 60)
			result += parseInt(arr[i]) * m;
		return result;
	}

	function displayData() {
		var html = '';
		if (sortedData == null || sortedData.length == 0)
			html = '<tr><td colspan="7" style="text-align:center;padding-top:20px;"><i>No results</i></td></tr>';
		else
			for (var i in sortedData) {
				var item = sortedData[i];
				var actions = '';
				if (item.allowed)
					for (var x in options.actions) {
						var act = options.actions[x];
						actions += '<a data-handler="' + x + '" class="action" taskId="' + item.id + '" href="#">[' + act.title + ']</a> ';
					}
				html += '<tr' + (!item.allowed ? ' class="disabled"' : '') + '>' +
					'<td><img src="' + window.links.baseUrl + '/images/gui/' + item.dziedzina.toLowerCase() + '.png" title="' + item.dziedzina + '" alt="' + item.dziedzina + '" /></td>' +
					'<td>' + (item.kategoria !== undefined ? item.kategoria : 'n/a') + '</td>' +
					'<td>' + item.poziom + '</td>' +
					'<td>' + parseFloat(item.cena * (1.0 + vat)).toFixed(2) + '</td>' +
					'<td>' + item.kara + '</td>' +
					'<td>' + formatInterval(item.czas) + '</td>' +
					'<td>' + actions + '</td>' +
					'</tr>';
			}
		BROWSER.find('.tasksBoxBody').html(html);
		for (var x in options.actions) {
			var objects = BROWSER.find('a.action[data-handler="' + x + '"]');
			objects.click(function() {
				var taskId = $(this).attr('taskId');
				var x = $(this).attr('data-handler');
				options.actions[x].handler(findTask(taskId), $(this), options);
				return false;
			});
		}
	}

	function refresh() {
		options.enable(false);
		BROWSER.find('.tasksBoxWait').find('td').text('Please wait...');
		$.ajax({
			type: 'GET',
			url: options.endpoint,
			data: options.endpointParams,
			success: function(data) {
				if (data.error) {
					BROWSER.find('.tasksBoxWait').find('td').text(data.error);
					return;
				}
				options.maxTasks = data.max;
				options.tasks = data.cnt;
				BROWSER.find('.tasksBoxCount').text(options.tasks);
				BROWSER.find('.tasksBoxMaxCount').text(options.maxTasks);
				options.workerList = data.workerList;
				options.city = data.city;
				options.periodDays = data.periodDays;
				originalData = data.data;
				filteredData = originalData;
				sortedData = filteredData;
				installControls();
				BROWSER.find('.tasksBoxWait').fadeOut(400, function() {
					displayData();
					BROWSER.find('.tasksBoxContainer').fadeIn();
				});
			},
			error: function(xhr, status, error) {
				BROWSER.find('.tasksBoxWait').find('td').text(status + ' ' + error);
			},
			complete: function() {
				options.enable(true);
			}
		});
	}

	var dlgTemplate =
		'<div class="biuroZleceniaXrDialogCls" xid="biuroZleceniaXrDialog">' +
		'	<table class="tasksBoxWait">' +
		'		<tr>' +
		'			<td>Please wait...</td>' +
		'		</tr>' +
		'	</table>' +
		'	<div class="tasksBoxContainer">' +
		'		<table class="tasksBoxContainerOuterTable">' +
		'			<thead>' +
		'				<tr>' +
		'					<th>' +
		'						<a class="sort" data-field="dziedzina" href="#">Field</a><br>' +
		'						<select class="filter" data-field="dziedzina" name="filter_dziedzina">' +
		'							<option value="" selected="selected"></option>' +
		'							<option value="Mathematics">Math</option>' +
		'							<option value="Physics">Phys</option>' +
		'							<option value="Biology">Biol</option>' +
		'							<option value="Chemistry">Chem</option>' +
		'						</select>' +
		'					</th>' +
		'					<th>' +
		'						<a class="sort" data-field="kategoria" href="#">Category</a><br>' +
		'						<input size="10" class="filter text" data-field="kategoria" type="text" value="" name="filter_kategoria"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="poziom" href="#">Level</a><br>' +
		'						<select class="filter" data-field="poziom" name="filter_poziom">' +
		'							<option value="" selected="selected"></option>' +
		'							<option value="Łatwe">Easy</option>' +
		'							<option value="Trudne">Hard</option>' +
		'							<option value="Bardzo trudne">Very hard</option>' +
		'						</select></th>' +
		'					<th>' +
		'						<a class="sort" data-field="cena" href="#">Price [zł]</a><br>' +
		'						<input size="10" class="filter numeric" data-field="cena" type="text" value="" name="filter_cena"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="kara" href="#">Penalty [%]</a><br>' +
		'						<input size="10" class="filter numeric" data-field="kara" type="text" value="" name="filter_kara"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="czas" href="#">Time</a><br>' +
		'						<input size="10" class="filter time" data-field="czas" type="text" value="" name="filter_czas"></th>' +
		'					<th></th>' +
		'				</tr>' +
		'			</thead>' +
		'			<tbody class="tasksBoxBody">' +
		'			</tbody>' +
		'		</table>' +
		'		<div>' +
		'			<span style="float:right"><span class="tasksBoxCount">?</span> / <span class="tasksBoxMaxCount">?</span></span>' +
		'		</div>' +
		'	</div>' +
		'</div>';

	BROWSER = $(dlgTemplate);
	BROWSER.dialog({
		title: options.title,
		modal: true,
		autoOpen: true,
		closeOnEscape: false,
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		open: function() {
			refresh();
		},
		close: function() {
			BROWSER.find('.tasksBoxBody').html('');
			BROWSER.find('.tasksBoxContainer').hide();
			BROWSER.find('.tasksBoxWait').show();
			$(this).parent().remove();
		},
		position: {
			my: "center",
			at: "center",
			of: window
		},
		draggable: true,
		resizable: false,
		width: 950,
		height: 450
	});

	BROWSER.find('.tasksBoxBodyRefresh').click(function() {
		BROWSER.find('.tasksBoxContainer').fadeOut(400, function() {
			BROWSER.find('.tasksBoxWait').fadeIn(400, refresh);
		});
		return false;
	});
}
